/*
	JavaScript with no callback
	Command line demo
	(c) 2015 Xul.fr
*/	


function fibo(n) 
{
    if (n < 2) return n
    return fibo(n-2) + fibo(n-1)
}

function getFibo(fn) {
	var x = fibo(20)
	fn(x)	
}

// 1) What we want to avoid: Callback with lambda function
//    Defining a function (display) with a function as parameter,
//    to be called with the definition of a lambda function as argument 

console.log("Using a callback:")

getFibo(function(x) {
	console.log("Fibo(20) = " + x) 
})	


// 2) Generator

console.log("Using a generator:")

function *gen() {
  var fiboResult	
  yield fiboResult = fibo(20)
  yield console.log("Generator: fibo(20)=" + fiboResult)
}

var g = gen();
g.next()  // call fibo
g.next()  // display



// 3) Promise

console.log("Using a promise:")

function display2(x) {
	console.log("Promise: fibo(20)="  + x)
}

function p(fn) {
	var fiboResult =  fibo(20)
	fn(fiboResult)
}

var promise = new Promise(p)
promise.then(display2)

console.log("Promise done.")



// 4) Double call back
//    display after dblFibo to be executed
//    dblFibo after fibo to be executed

console.log("Chaining callbacks:")

function getDouble(dbl) {
	var x = fibo(20)
	dbl(x)		
}

function dblFibo(x, fn) {
	var d = x * 2
	fn(d)
}

getDouble(function(x) {
	dblFibo(x, function(y) {
		console.log("Chaining callbacks, fibo(20) * 2 = " + y)
	}) 
})	
	

// 5) Replacing double callback by chaining promises (with simple callback)

function p1(fn) {
	var fiboResult = fibo(20) 
	fn(fiboResult)
}

function dblFibo2(x) {
	return x * 2
}

function display3(x) {
	console.log("Chaining promises: fibo(20) * 2 = "  + x)
}

var promise1 = new Promise(p1)

promise1.then(dblFibo2).then(display3)
